<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Generador de Reproductor HTML5</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px; }
        .container { background: #fff; padding: 20px; border-radius: 8px; max-width: 500px; margin: 0 auto; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #333; }
        label { display: block; margin-top: 10px; font-weight: bold; }
        input[type="text"], select { width: 100%; padding: 8px; margin-top: 5px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        input[type="submit"] { width: 100%; background-color: #28a745; color: white; padding: 10px; border: none; margin-top: 20px; cursor: pointer; border-radius: 4px; font-size: 16px; }
        input[type="submit"]:hover { background-color: #218838; }
    </style>
</head>
<body>

<div class="container">
    <h2>Configurar Reproductor</h2>
    <form action="process.php" method="post">
        
        <label>Nombre de la Radio:</label>
        <input name="nombre" type="text" required placeholder="Ej: Mi Radio Online" />

        <label>IP del Streaming (Sin http):</label>
        <input name="ip" type="text" required placeholder="Ej: 5.135.192.244" />

        <label>Puerto:</label>
        <input name="port" type="text" required placeholder="Ej: 9990" />

        <label>URL del Logo (Imagen JPG/PNG):</label>
        <input name="logo" type="text" required value="https://empresarialhost.com/4GeneradorHTML5/picpink.jpg" />

        <label>Mostrar Oyentes:</label>
        <select name="oyentes">
            <option value="true">SI</option>
            <option value="false">NO</option>
        </select>

        <label>Versión Shoutcast:</label>
        <select name="version">
            <option value="1">v1</option>
            <option value="2">v2</option>
        </select>

        <label>Auto Play:</label>
        <select name="autoplay">
            <option value="true">SI</option>
            <option value="false">NO</option>
        </select>

        <input type="submit" value="Generar Reproductor" />
    </form>
</div>

</body>
</html>